package doABC.Multiname;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import doABC.CpoolInfo;
import FlashReader.SWF;
import FlashReader.SwfTools;


public class MultinameKindQName extends SwfTools{

	private CpoolInfo cpool;
	
	private int start;
	private int end;
	//struktury
	private int ns=-1;
	private int name=-1;
	

	public MultinameKindQName(CpoolInfo cpool, int ns, int name){
		super();
		this.cpool = cpool;
		this.ns = ns;
		this.name=name;
	}
	
	
	public MultinameKindQName(ByteBuffer bbuf,CpoolInfo cpool){
		super();
		this.cpool = cpool;
		multiname_kind_QName(bbuf);
	}
	
	
	private void  multiname_kind_QName(ByteBuffer bbuf){
		
		start = bbuf.position();
		
		ns = unsigned30int(bbuf);
		name = 	unsigned30int(bbuf);

		end = bbuf.position()-1;
	
		//if (!nsS.equals(""))
		//multiname_info.add(nsS + "::" +nameS );
		//else multiname_info.add(nameS );
		
		
	}


	public int getStart() {
		return start;
	}


	public int getEnd() {
		return end;
	}


	public int getNs() {
		return ns;
	}


	public int getName() {
		return name;
	}
	
	
	public String getNs_string() {
		if ( ns ==0)
			return "*";
		return cpool.getNamespaces().get(ns).getName_string();

	}


	public String getName_string() {
		if ( name ==0)
			return "*";
		return cpool.getStrings().get(name).getUtf8_string();

	}
	

	public String String(){
		String wynik ="";
		wynik+="\n---#--- option_info "+SWF.msgs.getString("Position")+": " + start + "\n\n";
		
		wynik+= "ns: " + getNs_string()+"\n";
			
		wynik+= "name: " + getName_string()+"\n";
			
		wynik+="\n---!!--- "+SWF.msgs.getString("Position")+":  "+end;
		
		return wynik;
		
		
	}
	
	public String toString(){
		String wynik ="";
		if (!getNs_string().equals(""))
			wynik+=  getNs_string() + "::" +getName_string();
		else wynik += getName_string();

		return wynik;
	}
	
	public ArrayList<Byte> toByteCode(){
		ArrayList<Byte> result = new ArrayList<Byte>();
		
		if (  ns!=-1){
			ArrayList<Byte> tmp =getUI32(ns);
			for (int i=0;i<tmp.size();i++)
				result.add(tmp.get(i));
		}
		
		
		if (  name!=-1){
			ArrayList<Byte> tmp =getUI32(name);
			for (int i=0;i<tmp.size();i++)
				result.add(tmp.get(i));
		}
		
		return result;
	}
	
	
	
	
}
